﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EventReaderExample
{
  class Program
  {
    static void Main( string[] args )
    {
      string eventFile = @"C:\Paradox\Crusader Kings II\events\bastard_events.txt";
      
      Parsers.EventReader.Reader r = new Parsers.EventReader.Reader();
      //Passing a file to parse.
      //You can also parse an entire folder with r.ParseFolder().
      r.Parse( eventFile );

      //Parsed events are stored in dictionaries, with the event ID as the key.
      //Each type of event (character event, letter event, etc.) is stored in
      //its own dictionary.

      //To ease searching for an event, you can just pass the ID to r.GetEvent().

      //If there's a syntax error while parsing a file, it will not be parsed
      //and the error will be listed in r.Errors.

      Console.WriteLine("--Character Events--");
      foreach ( var e in r.CharacterEvents )
        Console.WriteLine( " " + e.Key );
      Console.WriteLine();

      Console.WriteLine( "--DilpResponse Events--" );
      foreach( var e in r.DiploResponseEvents )
        Console.WriteLine( " " + e.Key );
      Console.WriteLine();

      Console.WriteLine( "--Letter Events--" );
      foreach( var e in r.LetterEvents )
        Console.WriteLine( " " + e.Key );
      Console.WriteLine();

      Console.WriteLine( "--Narrative Events--" );
      foreach( var e in r.NarrativeEvents )
        Console.WriteLine( " " + e.Key );
      Console.WriteLine();

      Console.WriteLine( "--Province Events--" );
      foreach( var e in r.ProvinceEvents )
        Console.WriteLine( " " + e.Key );

      //Place breakpoint here to examine the contents of r.
      Console.Read();
    }
  }
}
